## -*-Tcl-*-
 # ###################################################################
 #  CSS mode - tools for editing CSS documents
 # 
 #  FILE: "cssMenu.tcl"
 #                                    created: 98-05-31 16.18.01 
 #                                last update: 01-11-03 23.16.27 
 #  Author: Johan Linde
 #  E-mail: <alpha_www_tools@go.to>
 #     www: <http://go.to/alpha_www_tools>
 #  
 # Version: 2.1.3
 # 
 # Copyright 1997-2001 by Johan Linde
 #  
 # This program is free software; you can redistribute it and/or modify
 # it under the terms of the GNU General Public License as published by
 # the Free Software Foundation; either version 2 of the License, or
 # (at your option) any later version.
 # 
 # This program is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 # GNU General Public License for more details.
 # 
 # You should have received a copy of the GNU General Public License
 # along with this program; if not, write to the Free Software
 # Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 # 
 # ###################################################################
 ##

#===============================================================================
# This file defines the CSS menu.
#===============================================================================

proc cssMenu {} {}

namespace eval css {}
namespace eval html {}

# Load if this is a global menu.
foreach __tmp {cssProperties htmlcssInit htmlMenuDefinition} {
	if { [catch {eval ${__tmp}.tcl}] } {
		beep
		alertnote "Loading of ${__tmp}.tcl failed"
		return
	}
}

if {![alpha::package vsatisfies -loose ${alpha::tclversion} 7.4b8]} {
set htmlCSSSub {{"" @Charset} {"" @Import} {"" @Media} {"" Text} {"" "Text Shadow"} {"" Tables} {"<O<B/R" "Reload in Browser"}
{"" "Key Bindings"} {"" "Preferences"}}
} else {
set htmlCSSSub {{"" @Charset} {"" @Import} {"" @Media} {"" Text} {"" "Text Shadow"} {"" Tables} {"<O<B/R" "Reload in Browser"}
{"" "Key Bindings"} {"" "Electrics"} {"" "Preferences"}}
}

set htmlBoxSub {{"" Margin} {"" Padding} {"" Border} {"" "Border Top"} {"" "Border Right"} 
{"" "Border Bottom"} {"" "Border Left"} {"" "Border Width"} {"" "Border Color"} {"" "Border Style"}}

set htmlVisualSub {{"" Display} {"" Positioning} {"" Floats} {"" "Z-index"} {"" "Text Direction"}
{"" "Content Size"} {"" "Vertical Align"} {"" "Visual Effects"}}

set htmlGeneratedSub {{"" Content} {"" Quotes} {"" Counters} {"" "Marker Offset"} {"" "List Style"}}

set htmlPagedSub {{"" @Page} {"" Size} {"" Marks} {"" "Page Breaks"} {"" Page}}

set htmlColorSub {{"" Color} {"" Background}}

set htmlFontsSub {{"" Font} {"" "Other Properties"} "(-" {"" "@Font Face"} {"" "Font Selection"} 
{"" Matching} {"" Synthesis} {"" Alignment} {"" "Other Descriptors"}}

set htmlUserSub {{"" Cursor} {"" Outline}}

set htmlAuralSub {{"" Volume} {"" Pause} {"" Cue} {"" "Play During"} {"" Spatial} {"" Voice} {"" Speech}}

set cssSubMenus [list CSS {Box Model} {Visual Formatting} {Generated Content} {Paged Media} \
  {Color and Background} Fonts {User Interface} Aural Colors URLs]

foreach __tmp [lrange $cssSubMenus 1 end] {
	menu::buildProc $__tmp "css::BuildSubMenuProc [list $__tmp] css::MenuItem"
}

proc css::BuildSubMenuProc {me proc} {
	global html::buildingWholeMenu
	if {![info exists html::buildingWholeMenu]} {html::ReadMenuKeys}
	return [list build [html::BuildOneMenu $me] "$proc -m" "" $me]
}

proc css::BuildMenuProc {} {
	global cssMenu cssSubMenus
	return [list build [css::BuildMenu0] "css::MenuItem -m" \
	  [lrange $cssSubMenus 1 end] $cssMenu]
}

proc css::BuildMenu0 {} {
	global cssSubMenus
	
	# Build submenus
	html::ReadMenuKeys	
	message "Building CSS menu"
	set CSSMenu [html::BuildOneMenu CSS]
	
	set me [lrange $CSSMenu 0 2]
	for {set i 1} {$i < 7} {incr i} {
		lappend me [list Menu -p css::MenuItem -m -n [lindex $cssSubMenus $i] {}]
	}
	append me " " [lrange $CSSMenu 3 5]
	for {set i 7} {$i < 9} {incr i} {
		lappend me [list Menu -p css::MenuItem -m -n [lindex $cssSubMenus $i] {}]
	}
	lappend me "(-"
	lappend me [list Menu -p css::MenuItem -m -n [lindex $cssSubMenus 9] {}]
	lappend me [list Menu -p css::MenuItem -m -n [lindex $cssSubMenus 10] {}]
	append me " " [lrange $CSSMenu 6 end]
	return $me
}

proc css::BuildMenuExtra {} {
	global htmlMenuKey
	catch {unset htmlMenuKey}
}

menu::buildProc cssMenu css::BuildMenuProc
hook::register menuBuild css::BuildMenuExtra cssMenu
html::BuildWholeMenu cssMenu

proc css::MenuItem {menu item} {
	global css::IsDescriptor mode::features global::features mode
	if {$menu == "Colors" || $menu == "URLs"} {
		if {($mode == "" || ([info exists mode::features($mode)] && ![lcontains mode::features($mode) cssMenu] && \
		  ![lcontains mode::features($mode) htmlUtilsMenu])) && \
		  [info exists global::features] && ![lcontains global::features cssMenu] && \
		  ![lcontains global::features htmlUtilsMenu]} {return}
	} elseif {($mode == "" || ([info exists mode::features($mode)] && ![lcontains mode::features($mode) cssMenu])) && \
	  [info exists global::features] && ![lcontains global::features cssMenu]} {return}
	if {$mode == "HTML" && ($item == "@Charset" || $item == "@Import" || $item == "Electrics" || $item == "Preferences")} {return}
	set css::IsDescriptor 0
	switch $menu {
		"Colors" {html::ColorsMenuProc $item}
		"URLs"	{html::URLWinMenuProc $menu $item}
		"Add New * To" {html::URLWinMenuProc $menu $item}
		default {
			switch $item {
				"Reload in Browser" {css::ReloadinBrowser}
				"Key Bindings" {css::MenuKeys}
				"Electrics" {
					if {$mode != "CSS"} {alertnote "Can only be changed when in CSS mode."; return}
					dialog::modifyModeFlags "CSS mode Electric Preferences"
				}
				"Preferences" {css::modifyFlags}
				"@Font Face" {css::FontFace}
				default {
					if {$menu == "Fonts" && $item != "Font" && $item != "Other Properties"} {
						set css::IsDescriptor 1
					}
					if {${css::IsDescriptor} && ![css::IsInAtRule font-face]} {
						alertnote "Font descriptors are only allowed inside a @font-face at-rule."
						return
					}
					css::Dialog [join [string tolower $item] -]
				}
			}
		}
	}
}

proc css::SetCase {elem} {
	global CSSmodeVars
	if {$CSSmodeVars(useLowerCase)} {
		return [string tolower $elem]
	} else {
		return [string toupper $elem]
	}
}

proc css::HTMLelement {elem} {
	replaceText [getPos] [selEnd] [css::SetCase $elem]
}

proc css::MenuKeys {} {
	global htmlMenuKey cssSubMenus
	html::ReadMenuKeys
	if {![catch {listpick -p "Choose a submenu to change key bindings in" \
	  [lsort $cssSubMenus]} meny] && $meny != ""} {
		catch {html::SetKeysInMenu $meny}
	}
	catch {unset htmlMenuKey}
}

proc css::GetHtmlWords {} {
	global html::ElemAttrOptional
	set words [array names html::ElemAttrOptional]
	regsub -all "\{INPUT \[^\}\]+\}" $words "" words
	regsub -all "\{LI \[^\}\]+\}" $words "" words
	lappend words INPUT
}

#===============================================================================
# Reload in Browser
#===============================================================================

proc css::ReloadinBrowser {} {
	global browserSig HTMLmodeVars
	if {$browserSig == "MSIE" || $browserSig == "OPRA"} {
		# returns window ids
		if {[catch {tclAE::build::resultData '$browserSig' WWW! LSTW} winnums]} {beep; message "No browser window."; return}
		# returns window info
		if {[catch {set winurl [lindex [tclAE::build::resultData '$browserSig' WWW! WNFO ---- [lindex $winnums 0]] 0]}] || ![regexp "://" $winurl]} {
			beep; message "Empty browser window."; return
		}
	} elseif {[catch {tclAE::build::resultData '$browserSig' core getd ---- {obj {form:prop, want:type(prop), seld:type(curl), from:obj {form:indx, want:type(cwin), seld:1, from:'null'()}}}} winurl] 
	|| ![regexp "://" $winurl]} {
		beep; message "Empty browser window."; return
	}
	if {[winDirty]} {
		html::SaveBeforeSending [lindex [winNames] 0]
	}
	# reloads window
	set flgs ""
	if {$browserSig != "MOSS"} {set flgs "FLGS 1"}
	eval AEBuild '$browserSig' WWW! OURL ---- "$winurl" $flgs
	if {![info exists HTMLmodeVars(browseInForeground)] || $HTMLmodeVars(browseInForeground)} {switchTo '$browserSig'}
}


